/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FilesRemover
extends JDialog {
    private final JTable table;
    private final Model model;
    private final Mode mode;
    private final JScrollPane scroll;
    private final JCheckBox headerSelectAll = new JCheckBox();
    private JButton btnDisableOrOpen;

    public static void showDialog(Window parent, List<Path> paths, Mode mode) {
        List<Row> rows = paths.stream().map(p -> new Row((Path)p, FilesRemover.displayNameFrom(p), mode)).collect(Collectors.toList());
        FilesRemover dlg = new FilesRemover(parent, rows, mode);
        dlg.setVisible(true);
    }

    public static void showDialog(Window parent, Map<String, Path> displayNameToPath, Mode mode) {
        List<Row> rows = displayNameToPath.entrySet().stream().map(e -> new Row((Path)e.getValue(), (String)e.getKey(), mode)).collect(Collectors.toList());
        FilesRemover dlg = new FilesRemover(parent, rows, mode);
        dlg.setVisible(true);
    }

    private void showError(String title, String message, Exception ex) {
        String details = ex == null ? "" : "\n\nDetails:\n" + ex.getMessage();
        JOptionPane.showMessageDialog(this, message + details, title, 0);
    }

    private boolean tryRename(Path from, Path to) {
        try {
            Files.move(from, to, new CopyOption[0]);
            return true;
        }
        catch (Exception ex) {
            this.showError(LanguageProvider.get((String)"gui.files_remover.error.rename_title"), String.format(LanguageProvider.get((String)"gui.files_remover.error.rename_msg"), from, to), ex);
            return false;
        }
    }

    private boolean tryDelete(Path p) {
        try {
            Files.deleteIfExists(p);
            return true;
        }
        catch (Exception ex) {
            this.showError(LanguageProvider.get((String)"gui.files_remover.error.delete_title"), String.format(LanguageProvider.get((String)"gui.files_remover.error.delete_msg"), p), ex);
            return false;
        }
    }

    private void tryOpen(Path p) {
        try {
            if (Files.exists(p, new LinkOption[0])) {
                Desktop.getDesktop().open(p.toFile());
            }
        }
        catch (Exception ex) {
            this.showError(LanguageProvider.get((String)"gui.files_remover.error.open_title"), String.format(LanguageProvider.get((String)"gui.files_remover.error.open_msg"), p), ex);
        }
    }

    private void tryReveal(Path p) {
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                return;
            }
            String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (os.contains("win")) {
                new ProcessBuilder("explorer.exe", "/select,", p.toAbsolutePath().toString()).start();
            } else if (os.contains("mac")) {
                new ProcessBuilder("open", "-R", p.toAbsolutePath().toString()).start();
            } else {
                Path dir;
                Path path = dir = Files.isDirectory(p, new LinkOption[0]) ? p : p.getParent();
                if (dir != null) {
                    new ProcessBuilder("xdg-open", dir.toAbsolutePath().toString()).start();
                }
            }
        }
        catch (Exception ex) {
            this.showError(LanguageProvider.get((String)"gui.files_remover.error.reveal_title"), String.format(LanguageProvider.get((String)"gui.files_remover.error.reveal_msg"), p), ex);
        }
    }

    private static Path withDisabledSuffix(Path p) {
        String n = FilesRemover.getFileName(p);
        return n.endsWith(".disabled") ? p : p.resolveSibling(n + ".disabled");
    }

    private static Path withoutDisabledSuffix(Path p) {
        String n = FilesRemover.getFileName(p);
        return n.endsWith(".disabled") ? p.resolveSibling(n.substring(0, n.length() - ".disabled".length())) : p;
    }

    private static String displayNameFrom(Path p) {
        return FilesRemover.getFileName(p);
    }

    private static String getFileName(Path p) {
        Path fn = p.getFileName();
        return fn == null ? p.toString() : fn.toString();
    }

    private static void syncDisplayNameSuffix(Row row, String oldFileName, String newFileName) {
        String dn = row.displayName == null ? "" : row.displayName;
        row.displayName = dn.endsWith(oldFileName) ? dn.substring(0, dn.length() - oldFileName.length()) + newFileName : newFileName;
    }

    private FilesRemover(Window parent, List<Row> rows, Mode mode) {
        super(parent, LanguageProvider.get((String)"gui.files_remover.title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.mode = mode;
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.model = new Model(rows, mode);
        this.table = new JTable(this.model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (rowIndex >= 0 && colIndex == 1) {
                    Row r = FilesRemover.this.model.rows.get(this.convertRowIndexToModel(rowIndex));
                    return r.path.toAbsolutePath().toString();
                }
                return super.getToolTipText(e);
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(880, 380);
            }
        };
        this.table.setRowHeight(28);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        JTextArea desc = new JTextArea(LanguageProvider.get((String)"gui.files_remover.desc.intro") + "\n" + (mode == Mode.JAR ? LanguageProvider.get((String)"gui.files_remover.desc.jar") : LanguageProvider.get((String)"gui.files_remover.desc.config")));
        desc.setEditable(false);
        desc.setBackground(UIManager.getColor("Panel.background"));
        desc.setBorder(new EmptyBorder(10, 10, 6, 10));
        TableColumnModel cm = this.table.getColumnModel();
        ButtonRenderer btnRenderer = new ButtonRenderer();
        cm.getColumn(2).setCellRenderer(btnRenderer);
        cm.getColumn(3).setCellRenderer(btnRenderer);
        cm.getColumn(4).setCellRenderer(btnRenderer);
        cm.getColumn(1).setCellRenderer(new FileNameRenderer());
        cm.getColumn(2).setCellEditor(new ButtonEditor(this.table){

            @Override
            protected void onClick(int viewRow, int col) {
                int r = this.table.convertRowIndexToModel(viewRow);
                Row row = FilesRemover.this.model.rows.get(r);
                if (row.mode == Mode.JAR) {
                    String oldName = FilesRemover.getFileName(row.path);
                    if (row.isDisabledJar()) {
                        Path t = FilesRemover.withoutDisabledSuffix(row.path);
                        if (FilesRemover.this.tryRename(row.path, t)) {
                            row.path = t;
                            String newName = FilesRemover.getFileName(t);
                            FilesRemover.syncDisplayNameSuffix(row, oldName, newName);
                            FilesRemover.this.model.refreshRow(r);
                        }
                    } else {
                        Path t = FilesRemover.withDisabledSuffix(row.path);
                        if (FilesRemover.this.tryRename(row.path, t)) {
                            row.path = t;
                            String newName = FilesRemover.getFileName(t);
                            FilesRemover.syncDisplayNameSuffix(row, oldName, newName);
                            FilesRemover.this.model.refreshRow(r);
                        }
                    }
                } else {
                    FilesRemover.this.tryOpen(row.path);
                }
                FilesRemover.this.layoutColumns();
                FilesRemover.this.updateHeaderCheck();
                FilesRemover.this.updateDisableOpenButtonLabel(FilesRemover.this.btnDisableOrOpen);
            }
        });
        cm.getColumn(3).setCellEditor(new ButtonEditor(this.table){

            @Override
            protected void onClick(int viewRow, int col) {
                int r = this.table.convertRowIndexToModel(viewRow);
                Row row = FilesRemover.this.model.rows.get(r);
                if (FilesRemover.this.tryDelete(row.path)) {
                    FilesRemover.this.model.removeRow(r);
                    FilesRemover.this.layoutColumns();
                    FilesRemover.this.updateHeaderCheck();
                    FilesRemover.this.updateDisableOpenButtonLabel(FilesRemover.this.btnDisableOrOpen);
                }
            }
        });
        cm.getColumn(4).setCellEditor(new ButtonEditor(this.table){

            @Override
            protected void onClick(int viewRow, int col) {
                int r = this.table.convertRowIndexToModel(viewRow);
                Row row = FilesRemover.this.model.rows.get(r);
                FilesRemover.this.tryReveal(row.path);
            }
        });
        final JTableHeader header = this.table.getTableHeader();
        this.headerSelectAll.setOpaque(false);
        this.headerSelectAll.setHorizontalAlignment(0);
        this.headerSelectAll.setToolTipText(LanguageProvider.get((String)"gui.files_remover.select_all_tooltip"));
        cm.getColumn(0).setHeaderRenderer((table, value, isSelected, hasFocus, row, column) -> {
            TableCellRenderer defaultRenderer = header.getDefaultRenderer();
            Component headerComponent = defaultRenderer.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(headerComponent.getBackground());
            panel.setForeground(headerComponent.getForeground());
            panel.setFont(headerComponent.getFont());
            if (headerComponent instanceof JComponent) {
                panel.setBorder(((JComponent)headerComponent).getBorder());
            }
            panel.setOpaque(true);
            this.headerSelectAll.setSelected(this.model.allSelected());
            this.headerSelectAll.setOpaque(false);
            panel.add((Component)this.headerSelectAll, "Center");
            return panel;
        });
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = header.columnAtPoint(e.getPoint());
                if (col == 0 && SwingUtilities.isLeftMouseButton(e)) {
                    boolean target = !FilesRemover.this.model.allSelected();
                    FilesRemover.this.model.setAllSelected(target);
                    FilesRemover.this.updateHeaderCheck();
                    FilesRemover.this.updateDisableOpenButtonLabel(FilesRemover.this.btnDisableOrOpen);
                }
            }
        });
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                FilesRemover.this.updateHeaderCheck();
                FilesRemover.this.updateDisableOpenButtonLabel(FilesRemover.this.btnDisableOrOpen);
            }
        });
        this.btnDisableOrOpen = new JButton(mode == Mode.JAR ? LanguageProvider.get((String)"gui.files_remover.disable_selected") : LanguageProvider.get((String)"gui.files_remover.open_selected"));
        JButton btnRemove = new JButton(LanguageProvider.get((String)"gui.files_remover.remove_selected"));
        JButton btnClose = new JButton(LanguageProvider.get((String)"gui.close"));
        this.btnDisableOrOpen.addActionListener(e -> {
            List<Integer> idxs = this.selectedRowIndices();
            if (idxs.isEmpty()) {
                JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.files_remover.select_first_warning_body"), LanguageProvider.get((String)"gui.files_remover.select_first_warning_title"), 2);
                return;
            }
            if (mode == Mode.JAR) {
                boolean enableMode = this.allSelectedDisabled(idxs);
                ArrayList<String> failures = new ArrayList<String>();
                for (int i = idxs.size() - 1; i >= 0; --i) {
                    String newName;
                    Path t;
                    String oldName;
                    int r = idxs.get(i);
                    Row row = this.model.rows.get(r);
                    if (enableMode) {
                        if (!row.isDisabledJar()) continue;
                        oldName = FilesRemover.getFileName(row.path);
                        t = FilesRemover.withoutDisabledSuffix(row.path);
                        if (this.tryRename(row.path, t)) {
                            row.path = t;
                            newName = FilesRemover.getFileName(t);
                            FilesRemover.syncDisplayNameSuffix(row, oldName, newName);
                            this.model.refreshRow(r);
                            continue;
                        }
                        failures.add(row.displayName);
                        continue;
                    }
                    if (row.isDisabledJar()) continue;
                    oldName = FilesRemover.getFileName(row.path);
                    t = FilesRemover.withDisabledSuffix(row.path);
                    if (this.tryRename(row.path, t)) {
                        row.path = t;
                        newName = FilesRemover.getFileName(t);
                        FilesRemover.syncDisplayNameSuffix(row, oldName, newName);
                        this.model.refreshRow(r);
                        continue;
                    }
                    failures.add(row.displayName);
                }
                if (!failures.isEmpty()) {
                    JOptionPane.showMessageDialog(this, String.format(LanguageProvider.get((String)"gui.files_remover.partial_disable_failures"), String.join((CharSequence)"\n", failures)), LanguageProvider.get((String)"gui.files_remover.partial_failure_title"), 2);
                }
            } else {
                for (int i = idxs.size() - 1; i >= 0; --i) {
                    int r = idxs.get(i);
                    this.tryOpen(this.model.rows.get((int)r).path);
                }
            }
            this.layoutColumns();
            this.updateDisableOpenButtonLabel(this.btnDisableOrOpen);
        });
        btnRemove.addActionListener(e -> {
            List<Integer> idxs = this.selectedRowIndices();
            if (idxs.isEmpty()) {
                JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.files_remover.select_first_warning_body"), LanguageProvider.get((String)"gui.files_remover.select_first_warning_title"), 2);
                return;
            }
            ArrayList<String> failures = new ArrayList<String>();
            for (int i = idxs.size() - 1; i >= 0; --i) {
                int r = idxs.get(i);
                Row row = this.model.rows.get(r);
                if (this.tryDelete(row.path)) {
                    this.model.removeRow(r);
                    continue;
                }
                failures.add(row.displayName);
            }
            if (!failures.isEmpty()) {
                JOptionPane.showMessageDialog(this, String.format(LanguageProvider.get((String)"gui.files_remover.partial_remove_failures"), String.join((CharSequence)"\n", failures)), LanguageProvider.get((String)"gui.files_remover.partial_failure_title"), 2);
            }
            this.layoutColumns();
            this.updateDisableOpenButtonLabel(this.btnDisableOrOpen);
        });
        btnClose.addActionListener(e -> this.dispose());
        JPanel bottom = new JPanel(new FlowLayout(2, 10, 8));
        bottom.add(this.btnDisableOrOpen);
        bottom.add(btnRemove);
        bottom.add(btnClose);
        this.scroll = new JScrollPane(this.table);
        JPanel root = new JPanel(new BorderLayout());
        root.add((Component)desc, "North");
        root.add((Component)this.scroll, "Center");
        root.add((Component)bottom, "South");
        this.setContentPane(root);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FilesRemover.this.layoutColumns();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(FilesRemover.this::layoutColumns);
            }
        });
        this.updateDisableOpenButtonLabel(this.btnDisableOrOpen);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void updateHeaderCheck() {
        JTableHeader header = this.table.getTableHeader();
        this.headerSelectAll.setSelected(this.model.allSelected());
        header.repaint();
    }

    private List<Integer> selectedRowIndices() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.model.getValueAt(i, 0))) continue;
            res.add(i);
        }
        return res;
    }

    private boolean allSelectedDisabled(List<Integer> selectedIdxs) {
        if (this.mode != Mode.JAR || selectedIdxs.isEmpty()) {
            return false;
        }
        for (int r : selectedIdxs) {
            if (this.model.rows.get(r).isDisabledJar()) continue;
            return false;
        }
        return true;
    }

    private void updateDisableOpenButtonLabel(JButton btn) {
        if (this.mode != Mode.JAR) {
            btn.setText(LanguageProvider.get((String)"gui.files_remover.open_selected"));
            return;
        }
        List<Integer> idxs = this.selectedRowIndices();
        if (!idxs.isEmpty() && this.allSelectedDisabled(idxs)) {
            btn.setText(LanguageProvider.get((String)"gui.files_remover.enable_selected"));
        } else {
            btn.setText(LanguageProvider.get((String)"gui.files_remover.disable_selected"));
        }
    }

    private void layoutColumns() {
        TableColumnModel cm = this.table.getColumnModel();
        JTableHeader header = this.table.getTableHeader();
        int colCount = cm.getColumnCount();
        int[] minWidths = new int[colCount];
        for (int c = 0; c < colCount; ++c) {
            int contentW;
            if (c == 1) continue;
            int headerW = this.getRendererPrefWidth(header.getDefaultRenderer(), header, cm.getColumn(c).getHeaderValue());
            if (c == 0) {
                r = this.table.getDefaultRenderer(Boolean.class);
                contentW = this.getMaxCellPrefWidth(r, c);
            } else {
                r = new ButtonRenderer();
                contentW = this.getMaxCellPrefWidth(r, c);
            }
            minWidths[c] = Math.max(headerW, contentW) + 12;
        }
        int fixedSum = 0;
        for (int c = 0; c < colCount; ++c) {
            if (c == 1) continue;
            fixedSum += Math.max(24, minWidths[c]);
        }
        int viewportW = this.scroll.getViewport().getWidth();
        if (viewportW <= 0) {
            viewportW = this.table.getPreferredSize().width;
        }
        for (int c = 0; c < colCount; ++c) {
            if (c == 1) continue;
            TableColumn tc = cm.getColumn(c);
            int w = Math.max(24, minWidths[c]);
            tc.setMinWidth(w);
            tc.setPreferredWidth(w);
            tc.setMaxWidth(w);
        }
        int leftover = Math.max(80, viewportW - fixedSum - 4);
        TableColumn fileCol = cm.getColumn(1);
        fileCol.setMinWidth(60);
        fileCol.setPreferredWidth(leftover);
        fileCol.setMaxWidth(Integer.MAX_VALUE);
        fileCol.setCellRenderer(new FileNameRenderer());
        this.table.revalidate();
        this.table.repaint();
    }

    private int getRendererPrefWidth(TableCellRenderer r, JComponent parent, Object value) {
        Component comp = r.getTableCellRendererComponent(this.table, value, false, false, -1, -1);
        comp.doLayout();
        return comp.getPreferredSize().width;
    }

    private int getMaxCellPrefWidth(TableCellRenderer r, int col) {
        int max = 0;
        int rows = Math.max(1, this.model.getRowCount());
        for (int i = 0; i < rows; ++i) {
            Object v;
            if (i < this.model.getRowCount()) {
                v = this.model.getValueAt(i, col);
            } else {
                switch (col) {
                    case 0: {
                        v = Boolean.FALSE;
                        break;
                    }
                    case 1: {
                        v = "";
                        break;
                    }
                    default: {
                        v = "";
                    }
                }
            }
            Component comp = r.getTableCellRendererComponent(this.table, v, false, false, i, col);
            comp.doLayout();
            max = Math.max(max, comp.getPreferredSize().width);
        }
        return max + 6;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame launcher = new JFrame("FilesRemover Demo");
            launcher.setDefaultCloseOperation(3);
            JLabel tip = new JLabel("<html><body style='padding:6px'>Choose what to open:<br>\u2022 <b>Mods</b>: scans relative <code>./mods</code> (non-recursive).<br>\u2022 <b>Configs</b>: scans relative <code>./config</code> (recursive).</body></html>");
            JButton openMods = new JButton("Open Mods (JAR mode)");
            JButton openConfigs = new JButton("Open Configs (CONFIG mode)");
            openMods.addActionListener(e -> {
                Path mods = ModListUtils.MODS_FOLDER;
                List<Path> files = FilesRemover.listFilesNonRecursive(mods);
                if (files.isEmpty()) {
                    JOptionPane.showMessageDialog(launcher, "No files found in ./mods.\nCreate the folder and put some files inside.", "Nothing to show", 1);
                    return;
                }
                FilesRemover.showDialog((Window)launcher, files, Mode.JAR);
            });
            openConfigs.addActionListener(e -> {
                Path cfg = Paths.get("config", new String[0]);
                List<Path> files = FilesRemover.listFilesRecursive(cfg);
                if (files.isEmpty()) {
                    JOptionPane.showMessageDialog(launcher, "No files found under ./config (searched recursively).\nCreate the folder and put some files inside.", "Nothing to show", 1);
                    return;
                }
                LinkedHashMap<String, Path> map = new LinkedHashMap<String, Path>();
                for (Path p : files) {
                    Path rel = cfg.toAbsolutePath().normalize().relativize(p.toAbsolutePath().normalize());
                    map.put(rel.toString(), p);
                }
                FilesRemover.showDialog((Window)launcher, map, Mode.CONFIG);
            });
            JPanel buttons = new JPanel(new FlowLayout(1, 12, 10));
            buttons.add(openMods);
            buttons.add(openConfigs);
            JPanel root = new JPanel(new BorderLayout());
            tip.setBorder(new EmptyBorder(8, 10, 0, 10));
            root.add((Component)tip, "North");
            root.add((Component)buttons, "Center");
            launcher.setContentPane(root);
            launcher.setSize(560, 160);
            launcher.setLocationByPlatform(true);
            launcher.setVisible(true);
        });
    }

    private static List<Path> listFilesNonRecursive(Path dir) {
        List<Path> list;
        block9: {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> s = Files.list(dir);
            try {
                list = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().collect(Collectors.toList());
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            s.close();
        }
        return list;
    }

    private static List<Path> listFilesRecursive(Path dir) {
        List<Path> list;
        block9: {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> s = Files.walk(dir, new FileVisitOption[0]);
            try {
                list = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().collect(Collectors.toList());
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            s.close();
        }
        return list;
    }

    public static enum Mode {
        JAR,
        CONFIG;

    }

    private static class Row {
        boolean selected;
        Path path;
        String displayName;
        final Mode mode;

        Row(Path p, String displayName, Mode m) {
            this.path = p;
            this.displayName = displayName;
            this.mode = m;
        }

        boolean isDisabledJar() {
            return this.mode == Mode.JAR && FilesRemover.getFileName(this.path).endsWith(".disabled");
        }
    }

    private static class Model
    extends AbstractTableModel {
        final String[] columns;
        final List<Row> rows;
        final Mode mode;

        Model(List<Row> rows, Mode mode) {
            this.rows = rows;
            this.mode = mode;
            this.columns = new String[]{"", LanguageProvider.get((String)"gui.files_remover.column.file"), mode == Mode.JAR ? LanguageProvider.get((String)"gui.files_remover.column.toggle") : LanguageProvider.get((String)"gui.files_remover.column.open"), LanguageProvider.get((String)"gui.files_remover.column.remove"), LanguageProvider.get((String)"gui.show_in_explorer_button")};
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int c) {
            return this.columns[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return c == 0 ? Boolean.class : Object.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c != 1;
        }

        @Override
        public Object getValueAt(int r, int c) {
            Row row = this.rows.get(r);
            switch (c) {
                case 0: {
                    return row.selected;
                }
                case 1: {
                    return row.displayName;
                }
                case 2: {
                    return row.mode == Mode.JAR ? (row.isDisabledJar() ? LanguageProvider.get((String)"gui.files_remover.enable") : LanguageProvider.get((String)"gui.files_remover.disable")) : LanguageProvider.get((String)"gui.files_remover.open");
                }
                case 3: {
                    return LanguageProvider.get((String)"gui.files_remover.remove");
                }
                case 4: {
                    return LanguageProvider.get((String)"gui.show");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object v, int r, int c) {
            if (c == 0) {
                this.rows.get((int)r).selected = (Boolean)v;
                this.fireTableRowsUpdated(r, r);
            }
        }

        void removeRow(int index) {
            this.rows.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        void refreshRow(int index) {
            this.fireTableRowsUpdated(index, index);
        }

        boolean allSelected() {
            if (this.rows.isEmpty()) {
                return false;
            }
            for (Row r : this.rows) {
                if (r.selected) continue;
                return false;
            }
            return true;
        }

        void setAllSelected(boolean sel) {
            for (int i = 0; i < this.rows.size(); ++i) {
                this.rows.get((int)i).selected = sel;
            }
            this.fireTableDataChanged();
        }
    }

    private static class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object v, boolean s, boolean f, int r, int c) {
            this.setText(String.valueOf(v));
            return this;
        }
    }

    private class FileNameRenderer
    extends DefaultTableCellRenderer {
        private final Color defaultColor = UIManager.getColor("Table.foreground");
        private final Color disabledColor = new Color(180, 0, 0);

        private FileNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelRow = table.convertRowIndexToModel(row);
            Row r = FilesRemover.this.model.rows.get(modelRow);
            c.setForeground(r.mode == Mode.JAR && r.isDisabledJar() ? this.disabledColor : this.defaultColor);
            this.setText(value == null ? "" : String.valueOf(value));
            return c;
        }
    }

    private static abstract class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected final JButton button = new JButton();
        protected final JTable table;
        protected int row;
        protected int col;
        protected Object label;

        ButtonEditor(JTable table) {
            this.table = table;
            this.button.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable t, Object v, boolean s, int r, int c) {
            this.row = r;
            this.col = c;
            this.label = v;
            this.button.setText(String.valueOf(v));
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.onClick(this.row, this.col);
            this.fireEditingStopped();
        }

        protected abstract void onClick(int var1, int var2);
    }
}

